globals [
 imported-jobs ;;an indicator whether the csv data file import was successful
 time ;;tracks the simulation time in minutes, while every tick represents five minutes.
 temp-color-store
 task-slot-1-full
 task-slot-2-full
 task-slot-3-full
 task-slot-4-full
 t-list
 i ;;index for while loops for plotting
 team-pa
 team-na
 team-in
 team-be
]

links-own [
 paffect ;;positive affect values for each link, ranging [0,1]
 naffect ;;negative affect values for each link, ranging [0,1]
 inform ;;instrumental: informational values for each link, ranging [0,1]
 behave ;;instrumental: behavioral values for each link, ranging [0,1]
 ;;creates data storing lists for each type of link
 pa-list
 na-list
 in-list
 be-list
 last-task-update ;;need to implement
]

extensions[csv]

breed [astronauts astronaut]
astronauts-own [
 role
 ;;individual differences collected from HERA
 values
 decision-making-style
 psychological-collectivism
 openness
 conscientiousness
 extraversion
 agreeableness
 neuroticism
 emotional-experience
 emotional-expression
 self-monitoring
 positive-response-to-stress
 suppression
 reappraisal
 education-level
 gender
 age
 working-memory
 general-cognitive-functioning
 social-desirability
]

breed [jobs job]
;;have a task importer  where things you want to know about a job are defined and set
;;make a csv first column is when task is introduced, task duration, four columns for each hera member
;;comment code
jobs-own[
 start-time
 duration
 assigned-to-CMD
 assigned-to-FE
 assigned-to-MS1
 assigned-to-MS2
 teaming-episode
 ;;task variables
 degree-of-self-leadership
 leadership-distribution
 goal-interdependence
 workload
 mts
 task-switching
 virtuality
 skill-differentiation
 team-size
 current?
]

;; Routine for the ABM Simulation setup
to setup
  clear-all
  set time 0
  setup-agents
  setup-links
  reset-ticks
  set imported-jobs False
  import-jobs
  set t-list list 0 0
  ask links [
  set pa-list list 0 0.5
  set na-list list 0 0.15
  set in-list list 0 0.5
  set be-list list 0 0.6
  set paffect 0.5
  set naffect 0.15
  set inform 0.5
  set behave 0.6
  ]
  refresh
end

;;Creates the four agents for the model: CMD, FE, MS1, MS2
to setup-agents
  create-astronauts 1 [
    set role "CMD"
    set shape "astronaut"
    set size 4
    set color white
    set xcor 0
    set ycor 9
    ;;individaul difference variables
    set values 4.4
    set decision-making-style 5.3
    set psychological-collectivism 5.9
    set openness 4.5
    set conscientiousness 4.1
    set extraversion 3.3
    set agreeableness 4.3
    set neuroticism 2.3
    set emotional-experience 0
    set emotional-expression 0
    set self-monitoring 4.6
    set positive-response-to-stress 0
    set suppression 3.5
    set reappraisal 7
    set education-level 1
    set gender 1
    set age 1
    set working-memory 0
    set general-cognitive-functioning 0
    set social-desirability 0
  ]
  ask patch 1 5 [
    set plabel "CMD"
  ]
  create-astronauts 1 [
    set role "FE"
    set shape "astronaut"
    set size 4
    set color white
    set xcor 0
    set ycor -9
    ;;individaul difference variables
    set values 5.1
    set decision-making-style 5.3
    set psychological-collectivism 7
    set openness 4.7
    set conscientiousness 5
    set extraversion 4.6
    set agreeableness 4.5
    set neuroticism 1.0
    set emotional-experience 0
    set emotional-expression 0
    set self-monitoring 3.1
    set positive-response-to-stress 0
    set suppression 3.5
    set reappraisal 7
    set education-level 1
    set gender 1
    set age 0
    set working-memory 0
    set general-cognitive-functioning 0
    set social-desirability 0
  ]
  ask patch 0.3 -5 [
    set plabel "FE"
  ]
  create-astronauts 1 [
    set role "MS1"
    set shape "astronaut"
    set size 4
    set color white
    set xcor -9
    set ycor 0
    ;;individaul difference variables
    set values 4.4
    set decision-making-style 5.0
    set psychological-collectivism 5.4
    set openness 3.4
    set conscientiousness 4.1
    set extraversion 3.3
    set agreeableness 4.3
    set neuroticism 2.3
    set emotional-experience 0
    set emotional-expression 0
    set self-monitoring 3.1
    set positive-response-to-stress 0
    set suppression 3.5
    set reappraisal 7
    set education-level 1
    set gender 1
    set age 1
    set working-memory 0
    set general-cognitive-functioning 0
    set social-desirability 0
  ]
  ask patch -5 0 [
    set plabel "MS1"
  ]
  create-astronauts 1 [
    set role "MS2"
    set shape "astronaut"
    set size 4
    set color white
    set xcor 9
    set ycor 0
    ;;individaul difference variables
    set values 3.8
    set decision-making-style 5.3
    set psychological-collectivism 5.7
    set openness 3.4
    set conscientiousness 3.9
    set extraversion 4.0
    set agreeableness 4.2
    set neuroticism 1.4
    set emotional-experience 0
    set emotional-expression 0
    set self-monitoring 3.5
    set positive-response-to-stress 0
    set suppression 2.5
    set reappraisal 4.2
    set education-level 1
    set gender 1
    set age 1
    set working-memory 0
    set general-cognitive-functioning 0
    set social-desirability 0
  ]
  ask patch 6 0 [
    set plabel "MS2"
  ]
end

;; Creates the setup for all links for the model
to setup-links
  ;ask all turtles to create a link to every other turtle that's not itself
  ask astronauts with [who != 0][
    create-link-to turtle 0
  ]
  ask astronauts with [who != 1][
    create-link-to turtle 1
  ]
  ask astronauts with [who != 2][
    create-link-to turtle 2
  ]
  ask astronauts with [who != 3][
    create-link-to turtle 3
  ]
  ask links [
   ;;set color rgb 255 0 0
   set color approximate-hsb 0 90 70
   set shape "curvy"
   set thickness 0.2
  ]
end

to update-paffect
  ask links [set paffect (paffect ^ decay-pa ) ;;time decay of ties
    ]
  ask jobs with [hidden? = false] [
    if (assigned-to-cmd = 1 and assigned-to-fe = 1) [pa-teaming 0 1 who pa-teaming 1 0 who]
    if (assigned-to-cmd = 1 and assigned-to-ms1 = 1) [pa-teaming 0 2 who pa-teaming 2 0 who]
    if (assigned-to-cmd = 1 and assigned-to-ms2 = 1) [pa-teaming 0 3 who pa-teaming 3 0 who]
    if (assigned-to-fe = 1 and assigned-to-ms1 = 1) [pa-teaming 1 2 who pa-teaming 2 1 who]
    if (assigned-to-fe = 1 and assigned-to-ms2 = 1) [pa-teaming 1 3 who pa-teaming 3 1 who]
    if (assigned-to-ms1 = 1 and assigned-to-ms2 = 1) [pa-teaming 2 3 who pa-teaming 3 2 who]
    ]
  ask links [
   if paffect > 1 [set paffect 1]
   if paffect < 0 [set paffect 0]
   set pa-list lput paffect pa-list ;;adds new paffect value to the end of the list
  ]
end

to update-naffect
  ask links [set naffect (naffect ^ decay-na) ;;time decay of ties
  ]
  ask jobs with [hidden? = false] [
    if (assigned-to-cmd = 1 and assigned-to-fe = 1) [na-teaming 0 1 who na-teaming 1 0 who]
    if (assigned-to-cmd = 1 and assigned-to-ms1 = 1) [na-teaming 0 2 who na-teaming 2 0 who]
    if (assigned-to-cmd = 1 and assigned-to-ms2 = 1) [na-teaming 0 3 who na-teaming 3 0 who]
    if (assigned-to-fe = 1 and assigned-to-ms1 = 1) [na-teaming 1 2 who na-teaming 2 1 who]
    if (assigned-to-fe = 1 and assigned-to-ms2 = 1) [na-teaming 1 3 who na-teaming 3 1 who]
    if (assigned-to-ms1 = 1 and assigned-to-ms2 = 1) [na-teaming 2 3 who na-teaming 3 2 who]
    ]
  ask links [
   if naffect > 1 [set naffect 1]
   if naffect < 0 [set naffect 0]
  set na-list lput naffect na-list ;;adds new naffect value to the end of the list
  ]
end

to update-inform
  ask links [set inform (inform ^ decay-in) ;;time decay of ties
  ]
  ask jobs with [hidden? = false] [
    if (assigned-to-cmd = 1 and assigned-to-fe = 1) [in-teaming 0 1 who in-teaming 1 0 who]
    if (assigned-to-cmd = 1 and assigned-to-ms1 = 1) [in-teaming 0 2 who in-teaming 2 0 who]
    if (assigned-to-cmd = 1 and assigned-to-ms2 = 1) [in-teaming 0 3 who in-teaming 3 0 who]
    if (assigned-to-fe = 1 and assigned-to-ms1 = 1) [in-teaming 1 2 who in-teaming 2 1 who]
    if (assigned-to-fe = 1 and assigned-to-ms2 = 1) [in-teaming 1 3 who in-teaming 3 1 who]
    if (assigned-to-ms1 = 1 and assigned-to-ms2 = 1) [in-teaming 2 3 who in-teaming 3 2 who]
    ]
  ask links [
   if inform > 1 [set inform 1]
   if inform < 0 [set inform 0]
  set in-list lput inform in-list ;;adds new informational value to the end of the list
  ]
end

to update-behave
  ask links [set behave (behave ^ decay-be) ;;time decay of ties
  ]
  ask jobs with [hidden? = false] [
    if (assigned-to-cmd = 1 and assigned-to-fe = 1) [be-teaming 0 1 who be-teaming 1 0 who]
    if (assigned-to-cmd = 1 and assigned-to-ms1 = 1) [be-teaming 0 2 who be-teaming 2 0 who]
    if (assigned-to-cmd = 1 and assigned-to-ms2 = 1) [be-teaming 0 3 who be-teaming 3 0 who]
    if (assigned-to-fe = 1 and assigned-to-ms1 = 1) [be-teaming 1 2 who be-teaming 2 1 who]
    if (assigned-to-fe = 1 and assigned-to-ms2 = 1) [be-teaming 1 3 who be-teaming 3 1 who]
    if (assigned-to-ms1 = 1 and assigned-to-ms2 = 1) [be-teaming 2 3 who be-teaming 3 2 who]
    ]
  ask links [
   if behave > 1 [set behave 1]
   if behave < 0 [set behave 0]
  set be-list lput behave be-list ;;adds new behavioral value to the end of the list
  ]
end

to pa-teaming [part1 part2 jobnum] ;;updates teaming for two participants. Cmd = 0, Fe = 1, Ms1 = 2, Ms2 = 3. part1 = perciever, part2 = percieved, jobnum = who of the job being called
    ask link part1 part2 [
      set paffect ( paffect    ;;previous tie value including decay over time
         + scale-pa ;;weight for scaling amount of change on each time step
         * (([      0.09 * values + 0.15 * decision-making-style + 0.2 * psychological-collectivism + 0.02 * openness + 0.15 * conscientiousness + 0.2 * extraversion + 0.52 * agreeableness - 0.5 * neuroticism + 0.31 * emotional-experience + 0.46 * emotional-expression + 0.22 * self-monitoring + 0.6 * positive-response-to-stress + 0.23 * reappraisal - 0.1 * education-level - 0.01 * gender + 0.19 * age + 0.15 * general-cognitive-functioning + 0.35 * social-desirability   ] of turtle part1);;attributes of perciever
         +([        0.09 * values + 0.15 * decision-making-style + 0.2 * psychological-collectivism + 0.02 * openness + 0.15 * conscientiousness + 0.2 * extraversion + 0.52 * agreeableness - 0.5 * neuroticism + 0.31 * emotional-experience + 0.46 * emotional-expression + 0.22 * self-monitoring + 0.6 * positive-response-to-stress + 0.23 * reappraisal - 0.1 * education-level - 0.01 * gender + 0.19 * age + 0.15 * general-cognitive-functioning + 0.35 * social-desirability      ] of turtle part2);;attributes of percieved
         +([        0.6 * goal-interdependence - 0.15 * workload - 0.4 * mts - 0.4 * virtuality + 0.15 * team-size      ] of turtle jobnum));;attributes of the task
           )
    ]
end

to na-teaming [part1 part2 jobnum] ;;updates teaming for two participants. Cmd = 0, Fe = 1, Ms1 = 2, Ms2 = 3. part1 = perciever, part2 = percieved, jobnum = who of the job being called
  ask link part1 part2 [
      set naffect ( naffect    ;;previous tie value including decay over time
         + scale-na ;;weight for scaling amount of change on each time step
         * (([      0 - 0.16 * values - 0.15 * decision-making-style - 0.4 * psychological-collectivism - 0.15 * openness + 0.15 * conscientiousness + 0.56 * neuroticism - 0.12 * emotional-experience - 0.27 * emotional-expression - 0.6 * positive-response-to-stress + 0.46 * suppression + 0.23 * reappraisal - 0.44 * education-level - 0.41 * gender - 0.42 * age + 0.4 * general-cognitive-functioning      ] of turtle part1);;attributes of perciever
         +([        0 - 0.16 * values - 0.15 * decision-making-style - 0.4 * psychological-collectivism - 0.15 * openness + 0.15 * conscientiousness + 0.56 * neuroticism - 0.12 * emotional-experience - 0.27 * emotional-expression - 0.6 * positive-response-to-stress + 0.46 * suppression + 0.23 * reappraisal - 0.44 * education-level - 0.41 * gender - 0.42 * age + 0.4 * general-cognitive-functioning     ] of turtle part2);;attributes of percieved
         +([        0.05 * goal-interdependence + 0.15 * workload + 0.15 * mts + 0.15 * virtuality + 0.09 * team-size      ] of turtle jobnum));;attributes of the task
           )
    ]
end

to in-teaming [part1 part2 jobnum] ;;updates teaming for two participants. Cmd = 0, Fe = 1, Ms1 = 2, Ms2 = 3. part1 = perciever, part2 = percieved, jobnum = who of the job being called
  ask link part1 part2 [
      set inform ( inform    ;;previous tie value including decay over time
         + scale-in ;;weight for scaling amount of change on each time step
         * (([      0.11 * values + 0.15 * decision-making-style + 0.25 * openness + 0.26 * conscientiousness + 0.3 * extraversion + 0.25 * agreeableness + 0.22 * neuroticism + 0.15 * emotional-expression - 0.15 * self-monitoring + 0.15 * positive-response-to-stress - 0.4 * suppression + 0.4 * reappraisal + 0.33 * education-level + 0.29 * age + 0.23 * general-cognitive-functioning   ] of turtle part1);;attributes of perciever
         +([        0.11 * values + 0.15 * decision-making-style + 0.25 * openness + 0.26 * conscientiousness + 0.3 * extraversion + 0.25 * agreeableness + 0.22 * neuroticism + 0.15 * emotional-expression - 0.15 * self-monitoring + 0.15 * positive-response-to-stress - 0.4 * suppression + 0.4 * reappraisal + 0.33 * education-level + 0.29 * age + 0.23 * general-cognitive-functioning     ] of turtle part2);;attributes of percieved
         +([        0.85 * goal-interdependence + 0.6 * workload + 0.4 * mts - 0.6 * virtuality + 0.15 * skill-differentiation + 0.15 * team-size      ] of turtle jobnum));;attributes of the task
           )
    ]
end

to be-teaming [part1 part2 jobnum] ;;updates teaming for two participants. Cmd = 0, Fe = 1, Ms1 = 2, Ms2 = 3. part1 = perciever, part2 = percieved, jobnum = who of the job being called
  ask link part1 part2 [
      set behave ( behave    ;;previous tie value including decay over time
         + scale-be ;;weight for scaling amount of change on each time step
         * (([      0 - 0.13 * values + 0.32 * psychological-collectivism + 0.46 * conscientiousness + 0.38 * extraversion + 0.28 * agreeableness - 0.37 * neuroticism + 0.15 * self-monitoring + 0.6 * positive-response-to-stress + 0.4 * reappraisal - 0.16 * age + 0.6 * working-memory + 0.09 * general-cognitive-functioning     ] of turtle part1);;attributes of perciever
         +([        0 - 0.13 * values + 0.32 * psychological-collectivism + 0.46 * conscientiousness + 0.38 * extraversion + 0.28 * agreeableness - 0.37 * neuroticism + 0.15 * self-monitoring + 0.6 * positive-response-to-stress + 0.4 * reappraisal - 0.16 * age + 0.6 * working-memory + 0.09 * general-cognitive-functioning     ] of turtle part2);;attributes of percieved
         +([        0 - 0.4 * degree-of-self-leadership + 0.6 * goal-interdependence + 0.6 * workload + 0.4 * mts - 0.4 * virtuality + 0.6 * skill-differentiation - 0.15 * team-size     ] of turtle jobnum));;attributes of the task
           )
    ]
end

to do-plotting
  set-current-plot "Tie Strength of CMD"
  clear-plot
  set-current-plot-pen "CMD -> FE"
  set i 0
  ask link 0 1 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]
  set-current-plot-pen "CMD -> MS1"
  set i 0
  ask link 0 2 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]
  set-current-plot-pen "CMD -> MS2"
  set i 0
  ask link 0 3 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]

  set-current-plot "Tie Strength of MS1"
  clear-plot
  set-current-plot-pen "MS1 -> CMD"
  set i 0
  ask link 2 0 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]
  set-current-plot-pen "MS1 -> MS2"
  set i 0
  ask link 2 3 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]
  set-current-plot-pen "MS1 -> FE"
  set i 0
  ask link 2 1 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]

  set-current-plot "Tie Strength of MS2"
  clear-plot
  set-current-plot-pen "MS2 -> CMD"
  set i 0
  ask link 3 0 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]
  set-current-plot-pen "MS2 -> MS1"
  set i 0
  ask link 3 2 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]
  set-current-plot-pen "MS2 -> FE"
  set i 0
  ask link 3 1 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]

  set-current-plot "Tie Strength of FE"
  clear-plot
  set-current-plot-pen "FE -> CMD"
  set i 0
  ask link 1 0 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]
  set-current-plot-pen "FE -> MS1"
  set i 0
  ask link 1 2 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]
  set-current-plot-pen "FE -> MS2"
  set i 0
  ask link 1 3 [
     while [i < length t-list] [
       if (displayn = "Positive affect") [plotxy item i t-list item i pa-list]
       if (displayn = "Negative affect") [plotxy item i t-list item i na-list]
       if (displayn = "Informational ties") [plotxy item i t-list item i in-list]
       if (displayn = "Behavioral ties") [plotxy item i t-list item i be-list]
       set i (i + 1)
     ]]
end


;;refreshes the display for the model based on the chooser values
to refresh
  ;;displays current tasks, hides non-current tasks. Repositions all tasks into correct task-slots
  ask jobs with [(teaming-episode = 1) and (hidden? = false) and not((start-time <= time) and (start-time + duration > time))] [
    if (ycor = -15) [set task-slot-1-full 0]
    if (ycor = -12) [set task-slot-2-full 0]
    if (ycor = -9) [set task-slot-3-full 0]
    if (ycor = -6) [set task-slot-4-full 0]
    hide-turtle
  ]
  ask jobs with [(hidden? = true) and (teaming-episode = 1) and (start-time <= time) and (start-time + duration > time)] [
    ifelse (task-slot-1-full = 0) [
      set ycor -15
      set task-slot-1-full 1]
    [ifelse (task-slot-2-full = 0) [
      set ycor -12
      set task-slot-2-full 1]
    [ifelse (task-slot-3-full = 0) [
      set ycor -9
      set task-slot-3-full 1]
    [if (task-slot-4-full = 0) [
      set ycor -6
      set task-slot-4-full 1]]]]
    show-turtle
  ]
  ;;colors astronauts based upon the current tasks
  ask astronauts [set color white]
  ask jobs with [(hidden? = false) and (teaming-episode = 1)] [
    set temp-color-store color
    if (assigned-to-cmd = 1) [ask astronaut 0 [set color temp-color-store]]
    if (assigned-to-fe = 1) [ask astronaut 1 [set color temp-color-store]]
    if (assigned-to-ms1 = 1) [ask astronaut 2 [set color temp-color-store]]
    if (assigned-to-ms2 = 1) [ask astronaut 3 [set color temp-color-store]]
  ]
  ;;displays the correct type of ties
  if (displayn = "Positive affect") [ask links [set color approximate-hsb (paffect * 140) 90 70]]
  if (displayn = "Negative affect")[ask links [set color approximate-hsb (naffect * 140) 90 70]]
  if (displayn = "Informational ties")[ask links [set color approximate-hsb (inform * 140) 90 70]]
  if (displayn = "Behavioral ties")[ask links [set color approximate-hsb (behave * 140) 90 70]]
  ;;displays the current time
  ask patch 15 15 [
    set plabel time
  ]
  do-plotting
end


;; The main simulation routine for the program
to go
  ;;steps forward in model time
  update-paffect
  update-naffect
  update-inform
  update-behave
  set team-pa team-scale-pa * (([paffect] of link 0 1 + [paffect] of link 0 2 + [paffect] of link 0 3 + [paffect] of link 1 0 + [paffect] of link 1 2 + [paffect] of link 1 3 + [paffect] of link 2 0 + [paffect] of link 2 1 + [paffect] of link 2 3 + [paffect] of link 3 0 + [paffect] of link 3 1 + [paffect] of link 3 2) / 12)
  set team-na team-scale-na * (([naffect] of link 0 1 + [naffect] of link 0 2 + [naffect] of link 0 3 + [naffect] of link 1 0 + [naffect] of link 1 2 + [naffect] of link 1 3 + [naffect] of link 2 0 + [naffect] of link 2 1 + [naffect] of link 2 3 + [naffect] of link 3 0 + [naffect] of link 3 1 + [naffect] of link 3 2) / 12)
  set team-in team-scale-in * (([inform] of link 0 1 + [inform] of link 0 2 + [inform] of link 0 3 + [inform] of link 1 0 + [inform] of link 1 2 + [inform] of link 1 3 + [inform] of link 2 0 + [inform] of link 2 1 + [inform] of link 2 3 + [inform] of link 3 0 + [inform] of link 3 1 + [inform] of link 3 2) / 12)
  set team-be team-scale-be * (([behave] of link 0 1 + [behave] of link 0 2 + [behave] of link 0 3 + [behave] of link 1 0 + [behave] of link 1 2 + [behave] of link 1 3 + [behave] of link 2 0 + [behave] of link 2 1 + [behave] of link 2 3 + [behave] of link 3 0 + [behave] of link 3 1 + [behave] of link 3 2) / 12)
  set time (time + 5) ;;time stored in five minute increments (one twelth of an hour)
  set t-list lput time t-list ;;adds the new time to the end of the t-list
  refresh
  tick
end


;; A subroutine for importing jobs from csv
to import-jobs
  ;; open a file on the system
  let filename "runData.csv"
  file-open filename

  ;; parses the file
  let header csv:from-row file-read-line
  while [ not file-at-end? ] [
    let items csv:from-row file-read-line
    create-jobs 1 [
      ;; not visible until (ticks = start-time)
      hide-turtle

      ;; make the tasks have a box shape
      set shape "box"
      set size 3

      set start-time item 4 items
      set duration item 6 items
      set assigned-to-MS1 item 9 items
      set assigned-to-FE item 10 items
      set assigned-to-CMD item 11 items
      set assigned-to-MS2 item 12 items
      set teaming-episode item 13 items
      ;;indepedent variables of each task
      set degree-of-self-leadership item 14 items
      set leadership-distribution item 15 items
      set goal-interdependence item 16 items
      set workload item 17 items
      set mts item 18 items
      set task-switching item 19 items
      set virtuality item 20 items
      set skill-differentiation item 21 items
      set team-size item 22 items

      set xcor 15
      set ycor 0
    ]
  ]
  ;; import complete, so close the file
  file-close
  set imported-jobs true
end

to-report link-paffects
  report [(list self paffect)] of links
end
to-report link-naffects
  report [(list self naffect)] of links
end
to-report link-inform
  report [(list self inform)] of links
end
to-report link-behave
  report [(list self behave)] of links
end
@#$#@#$#@
GRAPHICS-WINDOW
54
146
506
619
16
16
13.4
1
16
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
549
377
725
423
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
549
433
725
477
go once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
550
486
725
532
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
770
10
1157
152
Tie Strength of CMD
Time
Tie Strength
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"CMD -> MS1" 1.0 0 -16777216 true "" ""
"CMD -> MS2" 1.0 0 -7500403 true "" ""
"CMD -> FE" 1.0 0 -2674135 true "" ""

PLOT
1157
10
1541
153
Tie Strength of MS1
Time
Tie Strength
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"MS1 -> CMD" 1.0 0 -16777216 true "" ""
"MS1 -> MS2" 1.0 0 -7500403 true "" ""
"MS1 -> FE" 1.0 0 -2674135 true "" ""

PLOT
1156
150
1542
294
Tie Strength of MS2
Time
Tie Strength
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"MS2 -> CMD" 1.0 0 -16777216 true "" ""
"MS2 -> MS1" 1.0 0 -7500403 true "" ""
"MS2 -> FE" 1.0 0 -2674135 true "" ""

PLOT
770
150
1156
294
Tie Strength of FE
Time
Tie Strength
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"FE -> CMD" 1.0 0 -16777216 true "" ""
"FE -> MS1" 1.0 0 -7500403 true "" ""
"FE -> MS2" 1.0 0 -2674135 true "" ""

PLOT
53
10
758
138
Team Tie Strength
Time
Tie Strength
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"Positive Affect" 1.0 0 -16777216 true "" "plotxy time team-pa"
"Negative Affect" 1.0 0 -7500403 true "" "plotxy time team-na"
"Informational Ties" 1.0 0 -2674135 true "" "plotxy time team-in"
"Behavioral Ties" 1.0 0 -955883 true "" "plotxy time team-be"

CHOOSER
548
266
725
311
displayn
displayn
"Positive affect" "Negative affect" "Informational ties" "Behavioral ties"
0

BUTTON
549
321
725
367
Refresh
refresh
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
946
315
1101
375
decay-pa
1.035
1
0
Number

INPUTBOX
768
315
923
375
scale-pa
0.001
1
0
Number

TEXTBOX
773
297
923
315
Positive Affect Fit
14
0.0
1

TEXTBOX
769
388
919
406
NIL
14
0.0
1

TEXTBOX
773
380
923
398
Negative Affect Fit\n
14
0.0
1

INPUTBOX
767
397
922
457
scale-na
1
1
0
Number

INPUTBOX
945
397
1100
457
decay-na
1
1
0
Number

TEXTBOX
771
461
921
479
Informational Tie Fit
14
0.0
1

INPUTBOX
766
478
921
538
scale-in
0.0011
1
0
Number

INPUTBOX
943
478
1098
538
decay-in
1.04
1
0
Number

TEXTBOX
770
542
920
560
Behavioral Tie Fit
14
0.0
1

INPUTBOX
767
559
922
619
scale-be
7.0E-4
1
0
Number

INPUTBOX
945
559
1100
619
decay-be
1.03
1
0
Number

INPUTBOX
1126
314
1281
374
team-scale-pa
0.8
1
0
Number

INPUTBOX
1126
397
1281
457
team-scale-na
1
1
0
Number

INPUTBOX
1126
476
1281
536
team-scale-in
0.75
1
0
Number

INPUTBOX
1127
556
1282
616
team-scale-be
1.2
1
0
Number

@#$#@#$#@
## WHAT IS IT?

This model of team composition illustrates how team dynamics develop and evolve among study subjects in one of the Human Exploration Research Analog (HERA) campaigns. HERA is a part of the NASA Flight Analogs Project (FAP), which conducts research utilizing ground-based facilities that provide simulation scenarios and environments analogous to those encountered during exploration missions.

A campaign is defined as one integrated protocol with one primary mission scenario consisting of multiple missions. Currently, HERA represents an analog for simulation of isolation, confinement and remote conditions of mission exploration scenarios.

The specific campaign in this model is a 30-day duration test of four female study subjects. Therefore, this is a model of how the configuration of specific member and task attributes determines the emergence of team dynamics.

## HOW IT WORKS

The model measures affective and instrumental ties, each with two components. Affective ties consist of positive and negative affective ties and instrumental ties consist of informational (knowledge) and behavioral (productive) ties. Therefore, there are four types of ties captured in this model. In addition, since ties are not symmetric between individuals, e.g., individuals have differences that impact others' perceptions of them, we account for the directionality of ties among the members.

Each tick represents 5 minutes during the HERA campaign. At each tick, team members are assigned to a teaming episode, according to the "HERA playbook" of scheduled tasks for each of the four members. If team members are in a teaming episode together, then their ties are updated according to their own member attributes, their teammate's attributes, as well as the task attributes. If, on the other hand, team members are not in a teaming episode together, then we decay the relative strength of their ties using an exponential decay or "half-life" function.

The number of ongoing teaming episode tasks in the model are distinguished by colored boxes. Moreover, if members are part of the same teaming episode, they will be coded the same color, and the same color as the task they are currently engaged in.

Lastly, the roles of the four study subjects is Flight Engineer (FE), Commander (CMD), Mission Specialist 1 (MS1) and Mission Specialist 2 (MS2).

## HOW TO USE IT

Click the SETUP button to start the HERA campaign. Click GO ONCE to observe one tick during the campaign. Click GO indefinitely to run through the entire campaign. You may wish to use GO ONCE button for the first few steps to get a better sense of how the parameters affect the different ties.

### Visualization Controls

DISPLAYN controls which type of ties (i.e., positive affect, negative affect, informational or behavioral) plots at each tick. To toggle between the different ties, use the DISPLAYN dropdown to select the type of tie to plot, and then click REFRESH.

### Plots

TIE STRENGTH for each study subject (FE, CMD, MS1 and MS2) plots the tie strength of the specific study subject and each of her teammates.

TEAM TIE STRENGTH plots the team tie strength at the team level for the entire team.

## THINGS TO NOTICE

One thing to notice as the model runs is how tie strength changes for each study subject throughout time, due to a specific teaming episode or specific team member, for instance.

## THINGS TO TRY

This model has three parameters that determine how ties are updated each tick. In particular, SCALE-PA, SCALE-NA, SCALE-INF and SCALE-BE determine the weight (impact) that each tick has on tie strength for positive affect, negative affect, informational tie, and behavioral tie, respectively, whenever team members are engaged in a teaming episode together.

Also, DECAY-PA, DECAY-NA, DECAY-INF and DECAY-BE determine the rate of decay (e.g., exponential decay parameter) that each tick has on tie strength for positive affect, negative affect, informational tie, and behavioral tie, respectively, whenever team members are not in a teaming episode together.

Lastly, TEAM-SCALE-PA, TEAM-SCALE-NA, TEAM-SCALE-INF and TEAM-SCALE-BE determine the weight that dyadic ties (relationships) among the team members impact team level dynamics for positive affect, negative affect, informational ties and behavioral ties, respectively.

## EXTENDING THE MODEL

A possible extension would be adding moderators into the model to determine how interactions between individual attributes or between individual and task attributes, impact tie strength and team dynamics.

Another possible extension would be adding a decay function to account for the decreasing strength/impact of member and task attributes on tie strength over longer teaming episodes.

## RELATED MODELS

A related model is the mitigation model that uses "interventions", measured in Cost/intervention, to improve the strength of "weaker ties" among members.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

astronaut
false
15
Polygon -1 true true 105 90 105 30 120 15 180 15 195 30 195 90 120 90
Polygon -1 true true 105 90 120 195 90 285 105 285 135 285 150 225 165 285 195 285 210 285 180 195 195 90
Polygon -1 true true 195 90 240 150 225 180 165 105
Polygon -1 true true 105 90 60 150 75 180 135 105
Circle -16777216 true false 117 27 66
Rectangle -16777216 true false 120 180 180 195
Circle -2674135 true false 120 150 30
Circle -13345367 true false 120 120 30
Polygon -7500403 true false 60 150 45 180 75 180 60 150
Polygon -7500403 true false 240 150 225 180 255 180 240 150
Line -16777216 false 60 150 75 180
Line -16777216 false 225 180 240 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 6.0-M6
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="200"/>
    <metric>link-paffects</metric>
    <enumeratedValueSet variable="scale-in">
      <value value="5.0E-4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-na">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-pa">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-pa">
      <value value="8.0E-4"/>
      <value value="5.0E-4"/>
      <value value="2.0E-4"/>
      <value value="0.009"/>
      <value value="0.006"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="displayn">
      <value value="&quot;Positive affect&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-in">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-na">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-be">
      <value value="1.01"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-pa">
      <value value="1.035"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-in">
      <value value="1.035"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-be">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-be">
      <value value="0.001"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-na">
      <value value="1"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="300"/>
    <metric>link-paffects</metric>
    <enumeratedValueSet variable="scale-na">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-na">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-be">
      <value value="9.0E-4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-be">
      <value value="0.84"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-in">
      <value value="0.0015"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-be">
      <value value="1.03"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-pa">
      <value value="4.0E-4"/>
      <value value="7.0E-4"/>
      <value value="0.001"/>
      <value value="0.0013"/>
      <value value="0.0016"/>
      <value value="0.0019"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="displayn">
      <value value="&quot;Informational ties&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-na">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-pa">
      <value value="0.85"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-pa">
      <value value="1.035"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-in">
      <value value="0.83"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-in">
      <value value="1.04"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="300"/>
    <metric>link-paffects</metric>
    <enumeratedValueSet variable="scale-na">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-na">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-be">
      <value value="7.0E-4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-be">
      <value value="0.75"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-in">
      <value value="0.0011"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-be">
      <value value="1.03"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-pa">
      <value value="0.001"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="displayn">
      <value value="&quot;Informational ties&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-na">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-pa">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-pa">
      <value value="1"/>
      <value value="1.01"/>
      <value value="1.02"/>
      <value value="1.035"/>
      <value value="1.05"/>
      <value value="1.06"/>
      <value value="1.07"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-in">
      <value value="0.83"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-in">
      <value value="1.04"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="7700"/>
    <metric>link-paffects</metric>
    <metric>link-naffects</metric>
    <metric>link-behave</metric>
    <metric>link-inform</metric>
    <enumeratedValueSet variable="decay-na">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-in">
      <value value="1.04"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="displayn">
      <value value="&quot;Informational ties&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-na">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-in">
      <value value="0.83"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-be">
      <value value="0.75"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-be">
      <value value="1.03"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-be">
      <value value="7.0E-4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-na">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-pa">
      <value value="0.001"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay-pa">
      <value value="1.035"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="scale-in">
      <value value="0.0011"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="team-scale-pa">
      <value value="0.8"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

curvy
1.25
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
